# Contributing to Shower

You're always welcome to contibute! There are three repositories in Shower project:

- [Ribbon](https://github.com/shower/ribbon) theme for Shower
- [Shower](https://github.com/shower/shower) engine with Ribbon theme
- [Template](https://github.com/shower) for Shower engine and Ribbon theme

The most important part of the project is the [Shower](https://github.com/shower/shower) repository, containing [shower.js](https://github.com/shower/shower/blob/master/shower.js) file.

## Issues

Before starting to contribute to Shower please read through [Issues](https://github.com/shower/shower/issues?state=open) to see opened bugs and feature requests. If you have any feature to add to Shower, please make sure that you file an issue with your ideas first. If you've found a bug and want to fix it, please file an issue first. It might be a feature!


## Process

To contribute to Shower fork needed repository and start making changes. Don't forget to add upstream link to main original repository and keep your fork updated. When you finished send pull request back to original repository and supply clear description or link to existing issue.

## Code style

Please keep existing code style while contributing to Shower and be ready for code review by Shower authors and contributors. By historical reasons, Shower project is using tabs instead of spaces to indent code. It's not a big deal to keep this rule while contributing using you code editor options, even if your code style is 13.4 spaces. So, please use tabs instead of spaces for indentation.

## Language

English is the main language for Shower project. All discussions and commit messages should be in English no matter if it's good or bad. The second language of Shower is Russian. Offical Shower themes are always contains Cyrillic support for web fonts and support for Russian typography in text styling. All documentation to Shower is always localized to Russian.

---
If you have any question please ask [@shower_me](http://twitter.com/shower_me/) or file an [issue](https://github.com/shower/shower/issues?state=open).