# Contributing to Shower

You’re always welcome to contribute! Before contributing to Shower, please read through unified [issues list](https://github.com/shower/shower/issues) to see open bugs and feature requests. If you have any feature to add to Shower or found a bug and want to fix it, please make sure you [file an issue](https://github.com/shower/shower/issues/new) first.

## Process

Fork needed repository, create a branch for each feature or issue you’re dealing with and start making changes. Make sure you code doesn’t break tests if there are any. Once you’re finished, send pull request back to original repository: one feature or bug fix — one pull request, please don’t combine non-relevant changes into one pull request. Supply clear description of your changes and a link to existing issue.

## Code style

Please preserve existing code style while contributing to Shower and be ready for code review by Shower maintainers. It’s strongly recommended to install [EditorConfig](http://editorconfig.org) extension to your editor and validate your JavaScript changes using [JSHint](http://jshint.com/).

## Language

English is the main language for Shower project. All discussions and commit messages should be in English, no matter if it’s good or bad. The second language of Shower is Russian. Official Shower themes are always compatible with Cyrillic and Russian typography. All documentation to Shower is always localized to Russian.

---
Licensed under [MIT License](LICENSE.md).
