# Юзабилити-тестирование мобильного учебного приложения

## Цель тестирования
Целью юзабилити-тестирования является оценка удобства использования мобильного учебного приложения для студентов вуза, выявление проблем навигации и восприятия информации, а также формирование рекомендаций по улучшению пользовательского опыта.

## Описание тестируемого компонента
Тестируемым компонентом является дизайн мобильного учебного приложения.

Приложение предназначено для обучения студентов и включает следующие основные экраны:
- экран со списком доступных и записанных курсов;
- экран отдельного курса с информацией о прогрессе;
- экран со списком уроков внутри курса;
- элементы фильтрации и навигации.

Тестирование проводилось на визуальном прототипе интерфейса.

## Методология тестирования

### Формат тестирования
Использовалось дистанционное юзабилити-тестирование по сценариям.  
Участникам предлагалось выполнять типовые действия пользователя учебного приложения и комментировать возникающие затруднения.

### Участники
В тестировании приняли участие 10 студентов вуза.  
Все участники имели опыт использования мобильных приложений для обучения.

### Пользовательские задачи
В ходе тестирования участникам предлагалось выполнить следующие задачи:

1. Открыть приложение и просмотреть список доступных курсов.
2. Отфильтровать курсы по категории.
3. Выбрать курс «Веб-дизайн» и перейти к его описанию.
4. Ознакомиться с информацией о прогрессе и времени обучения.
5. Перейти к списку уроков курса.
6. Определить, какой урок был пройден последним.

## Основные наблюдения

### Положительные моменты
- Визуальный стиль интерфейса воспринимается как современный и привлекательный.
- Карточки курсов хорошо различимы и содержат ключевую информацию (название, длительность, рейтинг).
- Цветовое кодирование карточек помогает визуально различать курсы.
- Пользователи быстро находят экран курса и список уроков.
- Экран прогресса воспринимается как полезный элемент мотивации.

### Обнаруженные проблемы
- Назначение некоторых иконок не всегда очевидно без пояснений.
- Не всем пользователям сразу понятно, является ли курс завершённым или ещё активным.
- График активности не содержит пояснений и может быть непонятен пользователям без дополнительного контекста.
- Фильтрация курсов по категориям визуально заметна, но не все пользователи сразу понимают, что список прокручивается горизонтально.
- Отсутствует явное указание текущего урока в списке.

## Выводы
По результатам юзабилити-тестирования можно сделать вывод, что интерфейс мобильного учебного приложения в целом понятен и удобен для студентов вуза. Пользователи успешно выполняют основные сценарии взаимодействия и положительно оценивают визуальное оформление.

В то же время выявлены отдельные проблемы, связанные с недостаточной ясностью некоторых элементов интерфейса и визуализацией прогресса, что может снижать удобство использования приложения при длительной работе.

## Рекомендации по улучшению
На основании выявленных проблем рекомендуется:

- Добавить текстовые подсказки или подписи к иконкам и элементам управления.
- Явно обозначить статус курса (в процессе / завершён).
- Дополнить график активности поясняющим текстом или легендой.
- Сделать индикатор текущего урока более заметным.
- Улучшить визуальные подсказки для элементов фильтрации.