
## Инвариативные задания

* [1.1 Gitlab](#gitlab)
* [1.2 Диаграмма Гантта](#диаграмма-гантта)
* [2.1 Дизайн-макет](#дизайн-макет)
* [2.2 Гибкая разработка SCRUM](#гибкая-разработка-SCRUM)
* [3.1 Тестирование компонента образовательной среды](#тестирование-компонента-образовательной-среды)
* [3.2 System Usability Scale](#system-usability-scale)
* [3.3 Анализ работы модуля образовательной среды](#анализ-работы-модуля-образовательной-среды)
* [4.1 Issues](#issues)

## Вариативные задания
* [1.1 Инструменты прототипирования](#инструменты-прототипирования)
* [1.2 CSS фреймворки](#css-фреймворки)
* [2.1 Прототип ТЗ](#прототип-тз)
* [2.2 Первоначальный макет](#первоначальный-макет)
* [3.1 Анализ инструмента](#анализ-инструмента)
* [3.2 Фрагмент ТЗ](#фрагмент-тз)
* [4.1 Gitlab `merge`](#gitlab-merge)
* [4.2 Анализ методологии разработки](#анализ-методологии-разработки)


<!---->
## Gitlab

> GitLab — сайт и система управления репозиториями кода для Git, из дополнительных возможностей: собственная вики и система отслеживания ошибок.

#### Commit
```git commit -m '<message>'```
```git push origin master```

#### Branch
```git branch <name>```

#### Merge
```git merge <name>```

#### P.S. Watch repo

<!---->
## Диаграмма Гантта

> Диаграмма Гантта состоит из полос, ориентированных вдоль оси времени. Каждая полоса на диаграмме представляет отдельную задачу в составе проекта (вид работы), её концы — моменты начала и завершения работы, её протяженность — длительность работы. Вертикальной осью диаграммы служит перечень задач. Кроме того, на диаграмме могут быть отмечены совокупные задачи, проценты завершения, указатели последовательности и зависимости работ, метки ключевых моментов (вехи).

[ссылка на диаграмму](gantt.png)


<!---->
## Дизайн-макет

[ссылка на макет](design)


<!---->
## Гибкая разработка SCRUM

> Burn-down Chart – Диаграмма, показывающая соотношение прогресса оставшихся усилий к времени. Диаграмма не является обязательной к выполнению в рамках scrum, но делает прогресс более прозрачным.

> Burn-up Chart – Диаграмма, показывающая соотношение прогресса увеличивающихся мероприятий к времени. Диаграмма не является обязательной к выполнению в рамках scrum, но делает прогресс более прозрачным.


> Daily Scrum – Ежедневный Скрам митинг: ежедневное короткое результативное собрание которое проводится не более 15 минут, в нем участвует команда разработчиков, нужна для перепланирования задач/работ на наследующий день в рамках спринта. Обновления отражаются в Беклоге спринта.

> Definition of Done – Определение выполнения: общее понимание ожиданий, что именно программа должна выполнить для того, чтобы быть готовой к использованию. Администрируется командой разработчиков.

> Development Team – Команда разработчиков: роль команды в scrum которая несет ответственность за управление, организацию и выполнения всех работ, необходимых для создания качественного приращения рабочего продукта в каждом спринте.


> Emergence – Возникновение: процесс вступления в существование или значение новых фактов или знаний становятся более-менее определенными в текущей ситуации при реализации проекта.

> Empiricism – Эмпиризм: Тип управленческого процесса, в котором только прошлое воспринимается как определенное и, в котором решения принимаются на основе наблюдений, опыта и экспериментов. Эмпиризм опирается на три столпа: прозрачности, контроля и адаптации.

> Engineering standards – Технические стандарты: общий набор стандартов разработки и технологии, которые команда разработчиков применяет для создания качественного приращения программного обеспечения с каждым шагом.


> Forecast – Подборка (или функциональность): выбор элементов из списка невыполненных работ по продукту, которые команда разработчиков считает возможным для реализации в спринте.

> Increment – Приращение: определенная часть работающего программного обеспечения, которая добавляет полезный и работающий функционал к ранее созданной версии, сумма всех приращений – в целом – форма продукта.


> Product Backlog – Бэклог продукта: Невыполненная работа по продукту представляет собой упорядоченный список работ, которую необходимо выполнить для того, чтобы создавать, поддерживать и сохранять продукт. Управляется владельцем продукта.

> Product Backlog refinement – поддержка Беклога продукта: активность в спринте, благодаря которой владелец продукта и команда разработчиков добавляет функционал в Беклог продукта.

> Product Owner – Владелец продукта: роль в scrum методологии, которая несет ответственность за достижение максимальной ценности продукта, прежде всего за счет управления и составления бизнес и функциональных ожиданий для продукта к группе разработчиков.


> Scrum – Скрам: методы используемые при реализации проектов, в целом включают работы для поддержки скрам-команд при комплексной разработке ценностного для бизнеса продукта. Существует много направлений скрама, в большинстве случаев этот метод включает scrum команды, а также входящие в общую скам философию роли, методы и действия, как это определено в скрам-подходах.

> Scrum Board – Scrum-доска: физическая доска для визуализации информации для Скрам команды, часто используется для управления спринтом. Доска скрам является дополнительной функцией при реализации проектов в рамках scrum-методологии. Может быть заменена онлайн инструментами

> Scrum Guide – Руководство по скрам: Определяет суть и понятие скрам, написан и представлен Кен Швабером и Джефф Сазерлендом, создателей методологии scrum. Состоит из scrum команд, а также входящие в общую скрам-философию роли, методы и действия, которые связывают их вместе.

> Scrum Master – Скрам-Мастер: обозначает ведущую роль которая входит в scrum. Скрам мастер несет ответственность за руководство, подготовку, обучение и помощь scrum команде и его окружения в правильном понимании и использовании scrum.

> Scrum Team – Команды scrum: самоорганизующаяся команда состоит из владельца продукта, команды разработки и скрам-мастера.

> Scrum Values – Значение скрам: набор основополагающих ценностей и качеств, лежащих в основе методологии scrum; преданность делу, внимание, открытость, уважение и мужество.

> Self-organization – Самоорганизация: принцип управления, в котором команды проекта самостоятельно организовывают свою работу. Самоорганизация происходит в пределах границ и направлена на достижение цели. Команда решает, как лучше выполнить свою работу, а не управляется извне командой.

> Sprint – Спринт: Временные интервалы которые не должны превышать 4-х недель, спринт является отдельным, так называемым “контейнером” куда вносятся остальные события и скрам-мероприятия. В scrum методе управления проектами спринты выполняются последовательно, без промежуточных пробелов.

> Sprint Backlog – Беклог спринта: список задач и работ выполнение которых приблизит скрам команду к поставленным целям, зачастую, прогнозирует функциональность, требуемые параметры и характеристики при обеспечении этой функциональности. Управляется командой разработчиков.

> Sprint Goal – Цель спринта: краткое выражение цели-спринта, зачастую обозначает существующую бизнес-проблему, подлежащей решению в результате финального функционала продукта. Функциональные возможности по практике корректируются во время спринта при достижении поставленной цели.

> Sprint Planning – Планирование спринта: Временной промежуток, который не должен быть больше 8 часов, чтобы запустить спринт. Скрам команды используют его для проверки работ Беклога-продукта, определяя самые ценные направления которые будут прорабатываться дальше и схемы, которые будут использоваться в спринте.

> Sprint Retrospective – Ретроспектива спринта: временной промежуток не больше 3-х часов, в конце спринта. Скрам команды используют данный термин для того, чтобы проверить последние изменения в спринте, а также спланировать усовершенствования, которые должны быть приняты во время спринта который идет далее.

> Sprint Review – Аннотация спринта: временной промежуток не больше 4-х часов, который используется при завершении работы над каждым спринтом. Заинтересованные стороны и скрам команды используют этот термин, для проверки прироста функционала по-результатам проведенного спринта, а также комплексной оценки влияния выполненных задач на общий прогресс и обновление списка невыполненных работ по продукту (бэклога) в целях максимизации ценности следующего периода.

> Stakeholder – Заинтересованное лицо: Лицо, не входящее в скрам команду с особыми интересами и знанием продукта, который требуется для постепенных результатов. Связан с владельцем продукта и активно привлекается к скрам команде и аннотациях спринтов.


> Velocity – Быстрота: опционально, но часто используется, указание какая средняя часть работ из Бэклога превратился в функциональное приращение продукта во время спринта в scrum-команде, отслеживается разработчиками для использования в скрам команде.


<!---->
## Тестирование компонента образовательной среды

##### На примере системы Moodle.

> В системе Moodle соотвестствует ожиданиям только индексная страница и встроенный в систему функционал. Во всем остальном отвратительна в использовании (если вы не ищите платформу для чеклистов, маркировки блоков занятий). Интерфейс и навигация, по большей части, не консистентны и явно построены по общей модели.

<!---->
## System Usability Scale

##### На примере системы Moodle.

> Интерфейс кастомизирован, быть может даже это последняя версия системы Moodle. Внутренняя навигация курсам ужасна; похоже на полотно - прямо как этот Markdown. Интерфейс - 2/5.

> Функционал системы построен по MOOC стандартам, поддерживает много вещей, типа SCORM, оркестрации типовых тестов и т.д. Функционал - 4/5;

> По сравнению с EDX, при вложении усилий в который можно получить штуку лучше раза 3, Moodle выглядит устаревшей технологией.


<!---->
## Анализ работы модуля образовательной среды

##### На примере системы Moodle.

* Регистрация в системе
* Запись на курс
* Выполнение заданий
* Закрытие курса


<!---->
## Issues

#### P.S. Watch repo


<!---->
## Инструменты прототипирования

#### Adobe XD

> Adobe XD - это векторный инструмент, разработанный и опубликованный компанией Adobe Inc для разработки и создания прототипов пользовательского интерфейса для веб-приложений и мобильных приложений.

#### Sketch

> Sketch - это проприетарный редактор векторной графики для macOS от Apple, разработанный голландской компанией Bohemian Coding. Он получил награду Apple Design Award в 2012 году. Sketch был впервые выпущен 7 сентября 2010 года.

#### Figma

> Figma - векторный графический редактор кроссплатформенный от Figma. Предназначен для проектирования и создания интерфейсов, также создает интерактивные прототипы. Работает в двух форматах: в браузере и как клиентское приложение на рабочем столе пользователя.

[ссылка на презантацию](Prototype.pptx)


<!---->
## CSS-фреймворки

> CSS-фреймворк - библиотека примитивов для быстрой верстки

###### Bulma
###### Bootstrap
###### Semantic
###### Materialize

[ссылка на презентацию](Bootstrap.pptx)


<!---->
## Прототип ТЗ

[ссылка на ТЗ](fragment.pdf)

<!---->
## Первоначальный макет

[ссылка на макет](schema.png)

<!---->
## Анализ инструмента

##### На примере системы Moodle.

> Поднимается из образа с докерхаба двумя командами. На кастомизацию подобного ресурса нужно:

* Составление плана курсов
* Перенос в систему
* Кастомизация внешнего интерфейса

Итого: 20 гб + пара человек

<!---->
## Фрагмент ТЗ

[ссылка на ТЗ](fragment.pdf)

<!---->
## Gitlab `merge`

##### Merge
```git merge <name>```

#### P.S. Watch repo


<!---->
## Анализ методологии разработки




