'''Мой номер п/п в подгруппе - 9'''

def gen_bin_tree(height: int = 6, root: int = 9) -> dict:
    """
    Строит дерево в виде словаря {root: [left_subtree, right_subtree]},
    лист дерева представлен как {value: []}.
    Правила детей: left = 2 * root + 1, right = 2 * root - 1.
    
    Аргументы:
    height - высота дерева, тип int (по умолчанию 6),
    root - значение корня дерева, тип int (по умолчанию 9).
    """
    if height <= 0:
        '''Нет узла — пустое дерево'''
        return {}
    if height == 1:
        '''Лист'''
        return {root: []}

    left = 2 * root + 1
    right = 2 * root - 1

    '''Рекурсивный вызов для левого и правого поддеревьев
    с уменьшением высоты на 1
    '''
    left_sub = gen_bin_tree(height - 1, left)
    right_sub = gen_bin_tree(height - 1, right)

    return {root: [left_sub, right_sub]}
