# Лабораторная работа №2. Построение бинарного дерева

### 1.1 Постановка задачи

Разработайте программу на языке Python, которая будет строить бинарное дерево (дерево, в каждом узле которого может быть только два потомка). Отображение результата в виде словаря (как базовый вариант решения задания). Далее исследовать другие структуры, в том числе доступные в модуле `collections` в качестве контейнеров для хранения структуры бинарного дерева. 

Необходимо реализовать рекурсивный вариант `gen_bin_tree`

Алгоритм построения дерева должен учитывать параметры, переданные в качестве аргументов функции. Пример: 

```python
def gen_bin_tree(height=<number>, root=<number>):
    pass
```

Если параметры были переданы, то используются они. В противном случае используются параметры, указанные в варианте.

Дерево должно обладать следующими свойствами:

- В корне дерева (root) находится число, которое задает пользователь (индивидуально для студента).
- Высота дерева (height) задается пользователем (индивидуально для студента).
- Левый (left leaf) и правый потомок (right leaf) вычисляется с использованием алгоритмов, индивидуальных для каждого студента в группе и приведен ниже.

>Мой порядковый номер в подгруппе - 9: 
`Root = 9; height = 6, left_leaf = root*2+1, right_leaf = 2*root-1`.

### 1.2 Код программы

Была написана функция `gen_bin_tree`, создающая двоичное дерево в виде вложенного словаря.
В качестве ключа используется значение узла, а значение - список из двух поддеревьев: левого и правого.
Каждое поддерево, в свою очередь, оформляется в таком же виде - словарь, где ключом является значение узла, а значением список его потомков.

- Если высота дерева равна 0, возвращается пустой словарь `{}`
- Если высота дерева равна 1, создаётся лист `{value: []}`.
- Для вычисления значений потомков используются заданные правила:
левый потомок вычисляется как `2 * root + 1`, правый - `2 * root - 1`.

Рекурсивные вызовы функции выполняются до достижения заданной высоты дерева.
Функция возвращает вложенный словарь, описывающий полную структуру двоичного дерева.

func.py:
```python
'''Мой номер п/п в подгруппе - 9'''

def gen_bin_tree(height: int = 6, root: int = 9) -> dict:
    """
    Строит дерево в виде словаря {root: [left_subtree, right_subtree]},
    лист дерева представлен как {value: []}.
    Правила детей: left = 2 * root + 1, right = 2 * root - 1.
    
    Аргументы:
    height - высота дерева, тип int (по умолчанию 6),
    root - значение корня дерева, тип int (по умолчанию 9).
    """
    if height <= 0:
        '''Нет узла — пустое дерево'''
        return {}
    if height == 1:
        '''Лист'''
        return {root: []}

    left = 2 * root + 1
    right = 2 * root - 1

    '''Рекурсивный вызов для левого и правого поддеревьев
    с уменьшением высоты на 1
    '''
    left_sub = gen_bin_tree(height - 1, left)
    right_sub = gen_bin_tree(height - 1, right)

    return {root: [left_sub, right_sub]}

```

Также были написаны юнит-тесты, тестирующие функцию `gen_bin_tree`. Функция `assertEqual()` сравнивает результат работы функции с ожидаемым ответом.

test.py:
```python
import unittest
from func import gen_bin_tree


# Тесты
class TestMath(unittest.TestCase):
    def test_1(self):
        self.assertEqual(gen_bin_tree(), {9: [{19: [{39: [{79: [{159: [{319: []}, {317: []}]}, {157: [{315: []}, {313: []}]}]}, {77: [{155: [{311: []}, {309: []}]}, {153: [{307: []}, {305: []}]}]}]}, {37: [{75: [{151: [{303: []}, {301: []}]}, {149: [{299: []}, {297: []}]}]}, {73: [{147: [{295: []}, {293: []}]}, {145: [{291: []}, {289: []}]}]}]}]}, {17: [{35: [{71: [{143: [{287: []}, {285: []}]}, {141: [{283: []}, {281: []}]}]}, {69: [{139: [{279: []}, {277: []}]}, {137: [{275: []}, {273: []}]}]}]}, {33: [{67: [{135: [{271: []}, {269: []}]}, {133: [{267: []}, {265: []}]}]}, {65: [{131: [{263: []}, {261: []}]}, {129: [{259: []}, {257: []}]}]}]}]}]})

    def test_2(self):
        self.assertEqual(gen_bin_tree(3, 4), {4: [{9: [{19: []}, {17: []}]}, {7: [{15: []}, {13: []}]}]})

    def test_3(self):
        self.assertEqual(gen_bin_tree(4, 5), {5: [{11: [{23: [{47: []}, {45: []}]}, {21: [{43: []}, {41: []}]}]}, {9: [{19: [{39: []}, {37: []}]}, {17: [{35: []}, {33: []}]}]}]})

    def test_4(self):
        self.assertEqual(gen_bin_tree(4, 3), {3: [{7: [{15: [{31: []}, {29: []}]}, {13: [{27: []}, {25: []}]}]}, {5: [{11: [{23: []}, {21: []}]}, {9: [{19: []}, {17: []}]}]}]})

    def test_5(self):
        self.assertEqual(gen_bin_tree(0, 3), {})

    def test_6(self):
        self.assertEqual(gen_bin_tree(1, 10), {10:[]})

    def test_7(self):
        self.assertEqual(gen_bin_tree(2, 2), {2: [{5:[]}, {3: []}]})

# Запуск тестов
unittest.main(argv=[''], verbosity=2, exit=False)
```

### 1.3 Результаты работы

```
test_1 (__main__.TestMath.test_1) ... ok
test_1 (__main__.TestMath.test_1) ... ok
test_2 (__main__.TestMath.test_2) ... ok
test_2 (__main__.TestMath.test_2) ... ok
test_3 (__main__.TestMath.test_3) ... ok
test_4 (__main__.TestMath.test_4) ... ok
test_3 (__main__.TestMath.test_3) ... ok
test_4 (__main__.TestMath.test_4) ... ok
test_4 (__main__.TestMath.test_4) ... ok
test_5 (__main__.TestMath.test_5) ... ok
test_6 (__main__.TestMath.test_6) ... ok
test_7 (__main__.TestMath.test_7) ... ok

----------------------------------------------------------------------
Ran 7 tests in 0.002s

OK
```

## Трофимцова Екатерина, 2 курс, группа ИВТ-1, подгруппа 2