#!/bin/bash

# =============================================
# Скрипт автоматической установки ПО для Linux Mint
# =============================================

# Цвета для вывода в терминал
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Функция для печати статусов
print_status() {
    echo -e "${GREEN}[INFO]${NC} $1"
}

print_warning() {
    echo -e "${YELLOW}[WARN]${NC} $1"
}

print_error() {
    echo -e "${RED}[ERROR]${NC} $1"
}

# Проверка, запущен ли скрипт с правами root
if [ "$EUID" -ne 0 ]; then
    print_error "Этот скрипт требует прав суперпользователя. Используйте sudo."
    echo "Пример: sudo ./software_setup.sh"
    exit 1
fi

# Переменные со списками программ для установки
# 1. Программы из официальных репозиториев (через apt)
APT_PACKAGES=(
    "code" # Visual Studio Code
    "git-all"
    "maxima"
    "wxmaxima"
    "gimp"
    "python3-pip"
    "rustup"
    "far2l"
    "flameshot"
    "qalculate-gtk"
    "7zip"
    "firefox"
)

# 2. Программы, которые необходимо скачать как .deb пакеты
#    Формат: "Описательное_имя;URL_на_файл"
DEB_PACKAGES=(
    "vs-code; https://code.visualstudio.com/sha/download?build=stable&os=linux-deb-x64"
    "yandex-browser; https://browser.yandex.ru/download?os=linux&package=deb&x64=1&darktheme=0&banerid=6400000000&portal_testids=1114258%2F-1%2C1114347%2F-1%2C1124063%2F-1%2C1127618%2F-1%2C1349550%2F90&signature=U%2FqziHDqzAJF8b1wvllyzQOwNAHE2N1WyI8T8uQt9i%2FeiKHwPdbI8HEJzTvUHDKHffmeTAmRK9OiqejgWwZqrA%3D%3D"
)

# =============================================
# Начало выполнения скрипта
# =============================================

print_status "Начинается процесс автоматической установки ПО..."
echo ""

# Шаг 1: Обновление списка пакетов
print_status "Шаг 1: Обновление списка пакетов..."
apt update
apt-get update

# Шаг 2: Обновление уже установленных пакетов (рекомендуется)
print_status "Шаг 2: Обновление установленных пакетов..."
apt upgrade -y

# Шаг 3: Установка пакетов из репозиториев APT
print_status "Шаг 3: Установка пакетов из репозиториев APT..."
for package in "${APT_PACKAGES[@]}"; do
    print_status "Устанавливается: $package"
    apt install -y "$package"
    if [ $? -eq 0 ]; then
        print_status "$package успешно установлен."
    else
        print_error "Не удалось установить $package."
    fi
done

# Шаг 4: Установка .deb пакетов
print_status "Шаг 4: Установка .deb пакетов..."
TEMP_DIR="/tmp/software_setup_deb"
mkdir -p "$TEMP_DIR"

for package_info in "${DEB_PACKAGES[@]}"; do
    # Разделяем строку на имя и URL
    IFS=';' read -r -a package_data <<< "$package_info"
    PACKAGE_NAME="${package_data[0]}"
    PACKAGE_URL="${package_data[1]}"
    DEB_FILENAME=$(basename "$PACKAGE_URL")

    print_status "Скачивается и устанавливается: $PACKAGE_NAME"

    # Скачивание в временную директорию
    wget -O "$TEMP_DIR/$DEB_FILENAME" "$PACKAGE_URL"

    # Установка
    dpkg -i "$TEMP_DIR/$DEB_FILENAME"

    # Исправление возможных зависимостей
    apt install -f -y

    if [ $? -eq 0 ]; then
        print_status "$PACKAGE_NAME успешно установлен."
    else
        print_error "Не удалось установить $PACKAGE_NAME."
    fi
done

# Шаг 5: Установка приложений по инструкциям с официальных сайтов или с распаковкой архива

# Установка Docker
print_status "Скачивается и устанавливается: Docker"
# Add Docker's official GPG key:
sudo apt-get update
sudo apt-get install ca-certificates curl
sudo install -my 0755 -d /etc/apt/keyrings
sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg -o /etc/apt/keyrings/docker.asc
sudo chmod a+r /etc/apt/keyrings/docker.asc
# Add the repository to Apt sources:
echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/ubuntu \
  $(. /etc/os-release && echo "${UBUNTU_CODENAME:-$VERSION_CODENAME}") stable" | \
  sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
sudo apt-get update
sudo apt-get install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

# Установка PyCharm (может не установиться с российского IP-адреса)
print_status "Скачивается и устанавливается: PyCharm"
wget -O pycharm.tar.gz "hhttps://www.jetbrains.com/pycharm/download/download-thanks.html?platform=linux"
sudo tar -xzf pycharm.tar.gz -C /opt/

# Установка GitHub Desktop
print_status "Скачивается и устанавливается: GitHub Desktop"
## Direct copy-paste from official instrubtions
## Github Desktop for Ubuntu
## Get the @shiftkey package feed
wget -qO - https://apt.packages.shiftkey.dev/gpg.key | gpg --dearmor | sudo tee /usr/share/keyrings/shiftkey-packages.gpg > /dev/null
sudo sh -c 'echo "deb [arch=amd64 signed-by=/usr/share/keyrings/shiftkey-packages.gpg] https://apt.packages.shiftkey.dev/ubuntu/ any main" > /etc/apt/sources.list.d/shiftkey-packages.list'
## Install Github Desktop for Ubuntu
sudo apt update && sudo apt install -y github-desktop

# Установка Julia
print_status "Скачивается и устанавливается: Julia"
wget https://julialang-s3.julialang.org/bin/linux/x64/1.11/julia-1.11.7-linux-x86_64.tar.gz
tar zxvf julia-1.11.7-linux-x86_64.tar.gz

# Установка Zettlr
print_status "Скачивается и устанавливается: Zettlr"
curl -s --compressed "https://apt.zettlr.com/KEY.gpg" | gpg --dearmor | sudo tee /etc/apt/trusted.gpg.d/zettlr_apt.gpg > /dev/null
sudo curl -s --compressed -o /etc/apt/sources.list.d/zettlr.list "https://apt.zettlr.com/zettlr.list"
sudo apt update
sudo apt install -y zettlr

# Установка MiKTeX
print_status "Скачивается и устанавливается: MiKTeX"
curl -fsSL https://miktex.org/download/key | sudo gpg --dearmor -o /usr/share/keyrings/miktex.gpg
echo "deb [signed-by=/usr/share/keyrings/miktex.gpg] https://miktex.org/download/ubuntu jammy universe" | sudo tee /etc/apt/sources.list.d/miktex.list
sudo apt-get update
sudo apt-get install -y miktex

# Установка TeXstudio
print_status "Скачивается и устанавливается: TeXstudio"
sudo add-apt-repository ppa:sunderme/texstudio
sudo apt-get install -y texstudio

# Установка Anaconda
print_status "Скачивается и устанавливается: Anaconda"
wget https://repo.anaconda.com/archive/Anaconda3-2019.03-Linux-x86_64.sh
bash Anaconda3-2019.03-Linux-x86_64.sh -b

# Установка Google Chrome
print_status "Скачивается и устанавливается: Google Chrome"
wget https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb
sudo dpkg -yi google-chrome-stable_current_amd64.deb

# Установка расширений для VS Code
code --install-extension julialang.language-julia
code --install-extension ms-python.python
code --install-extension rust-lang.rust-analyzer

# Удаляем временную директорию
rm -rf "$TEMP_DIR"

# Шаг 6: Очистка кэша
print_status "Шаг 6: Очистка кэша пакетов..."
apt autoremove -y
apt clean

print_status "============================================="
print_status "Установка ПО завершена!"
print_status "============================================="

# Краткий отчет
echo ""
print_status "Краткий отчет:"
print_status "Установленные пакеты из APT: ${#APT_PACKAGES[@]}"
print_status "Установленные .deb пакеты: ${#DEB_PACKAGES[@]}"
print_status "Установленные по отдельной инструкции: Docker, PyCharm, GitHub Desktop, Julia, Zettlr, MiKTeX, TeXstudio, Anaconda, Google Chrome"
print_status "Установленные расширения для VS Code: Julia, Python, Rust"
echo ""
print_warning "Рекомендуется перезагрузить систему."
